
//ES6 PROMISE

const getMoviesIds = new Promise((resolve,reject)=>{
    setTimeout(()=>{
        resolve([1000,1001,1002,1003,1004]);
    },2000);
});

const getMovies = movieId =>{
    return new Promise((resolve,reject)=>{
        setTimeout(id =>{
            const movie = {
                title : 'The Old Guard',
                score : 6.5,
                rottenTomatoes : '81%',
                actor : 'Charlize Theron',
                releaseYear : 2020
            }
           resolve(`${id} , ${movie.title}, I
                    MDB:${movie.score}, 
                    year:${movie.releaseYear},
                    rottenTomatoes:${movie.rottenTomatoes}, 
                    actor: ${movie.actor}`);
        },1500,movieId);
    });
}


const getMoviesByYear = year =>{
    return new Promise((resolve,reject)=>{
        setTimeout(year =>{
            const movie1 = {
                title : 'Angel Has Fallen',
                score : 6.5,
                rottenTomatoes : '39%',
                actor : 'Gerald Butler',
                releaseYear : 2020
            }
            resolve(`This movie was released in the same year of ${year},
             ${movie1.title}, IMDB:${movie1.score}, year:${movie1.releaseYear}, 
             rottenTomatoes:${movie1.rottenTomatoes}, actor: ${movie1.actor}`);
        },1500,year);
    });
}

//ES8 ASYNC/AWAIT PROMISE HANDLING
async function getMoviesAsyncW(){
    const ids = await getMoviesIds;
    console.log(ids);
    const movie = await getMovies(ids[4]);
    console.log(movie);
    const sameYearMovie = await getMoviesByYear(2020);
    console.log(sameYearMovie);
    return movie;
}
getMoviesAsyncW();
//const result = getMoviesAsyncW();
//console.log(result);
// getMoviesAsyncW().then(result =>{
//     console.log('Here is the new result '+result);
// });




